; JFW 3.31 Script file for Microsoft Word, Office 97 and 2000.
; Copyright 1998, 1999  by Henter-Joyce, Inc.
; Build wd3312412r by Joseph K Stephen (formerly Dunn) last modified on 7 October 1999. 

include "winword.jsh" ; constants for Word 97
include "winword8.jsm" ; messages for Word 97
include "winword.jsm"
include "hjglobal.jsh"
Include "hjconst.jsh" ; constants for attributes, window classes
include "default.jsm"
use"magWord.jss"

function AutoStartEvent ()
let WordVersion = GetWordVersion ()
if WordVersion<=7 then
SwitchToScriptFile("word95","winword")
return
elif WordVersion==8 then
 SetIds97 ()
else SetIds()
endif
	let oWord = MSOGetMenuBarObject ();
	let oWord = oWord.Application; initializes a pointer to the Word application object

	if !oWord () then
		let oWord = GetObject ("Word.Application");
EndIf
;wwn292="tip of the day"
if (GetWindowName (GetFocus ())== wwn292)
	&& SdmGetFocus (GetFocus ())== 18 then ; on check box
	SdmSayControl (GetFocus (), 17) ; say the tip of the day
	SdmSayControl (GetFocus (), 18) ; say check box
endif ; tip of the day
if (WinWordFirstTime == 0) then
	let WinWordFirstTime = 1
	let globalDetectContext=detectContextOn ; on by default
	let globalDetectStyleChanges=DetectStylesOff ; off by default
	if GetVerbosity() == beginner then
SayExtendedHelpHotkey()
		Say(wmsg293, ot_help) ;"Use Insert plus the letter H for help in various dialog boxes"
Say(wmsg494, ot_help) ;"for a list of ms word short cut keys use insert + w"
	EndIf ; verbosity beginner
EndIf ; first time
; reset all table variables so tables are reported when we switch focus to word
let globalTablePriorRow=0
let globalTablePriorColumn=0 
let globalTableStart=-1 ; needs to be less than  0 as a table may be at position 0 in the document.
let globalTableCell=null
; reset spell checker trigger flag 
let spellCheckerTriggered=false ; reset.
EndFunction

Function AutoFinishEvent ()
let oWord = null
let globalTableCell=null
EndFunction

Void Function SetIds97 ()
; edit box in word 97 spellchecker
let CId_NotInDictionary_EditBox=CId_NotInDictionary_EditBox1
EndFunction

Function SetIds ()
; sets the id of the edit box in the Word 2000 spell checker 
let CId_NotInDictionary_EditBox=CId_NotInDictionary_EditBox2
EndFunction

Script ScriptFileName ()
ScriptAndAppNames(msgWordForWindows)
EndScript

Int Function GetWordVersion ()
var int nVersion
let nVersion = GetProgramVersion (GetAppFilePath ())
if (nVersion) then
	return nVersion
endif
EndFunction

Script SayWordVersion ()
	PerformScript SayAppVersion()
EndScript

Void Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
	HANDLE RealWindow,
	string RealWindowName,
	HANDLE AppWindow
let RealWindow = GetRealWindow(FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow(FocusWindow)
;wwc294="_sdm_"
if (StringContains (GetWindowClass (RealWindow), wwc294)) then
	; we are in an SDM dialog
	let GlobalRealWindow = RealWindow
	let GlobalRealWindowName = RealWindowName
	let GlobalFocusWindow = FocusWindow
		SaySDMFocusedWindow ()
Else ; not sdm
	;start of regular non-sdm logic
	if (GlobalPrevApp != AppWindow
	&& AppWindow != FocusWindow) then
		; we've switched to a different app main window,
		; and it does not have the focus, so announce it
		SayWindowTypeAndText(AppWindow)
	endif

	If ((GlobalPrevRealName != RealWindowName) ; name has changed
	|| (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
		If ((RealWindow != AppWindow)
		&& (RealWindow != FocusWindow)) then
			SayWindowTypeAndText(RealWindow)
		endif
	EndIf
	; now say the window with focus
	let GlobalFocusWindow = FocusWindow ; to access it from another routine
	if (WordVersion >= Word_8) then
		SayFocusedWindow ()
	else
		SayFocusedWindow()
	EndIf
EndIf ;end else sdm
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Int Function triggerSpellChecker (handle hwnd, int textColor, string buffer)
var
string textRGB

if getWindowClass(hwnd)==wc_NotInDictionary_EditBox then
	if getWindowName(getRealWindow(hwnd))==wn_spellingAndGrammar then
		let textRGB=colorToRGBString(textColor)
		if textRGB==colorMisspelledWord || textRGB==colorGrammaticalError then
			if (GlobalCurrentControl == CId_NotInDictionary_EditBox) then
				if not spellCheckerTriggered then
					let spellcheckerTriggered=true 		
					readErrorAndSuggestion(TextColor,buffer)
				endIf
			endIf
		endIf
	endIf
else
; the error has finished being written.
	let spellcheckerTriggered=false
EndIf
return spellcheckerTriggered
EndFunction

Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes, int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
if (ProcessSelectText(nAttributes,buffer)) then
	return
endif
if (sFrameName == "") then
; check if the text is being written to the spellchecker edit box
; the test is here as it is written highlighted in Word 97 but not highlighted in word 2000
	if triggerSpellchecker(hwnd,nTextColor,buffer) then
		return
	endIf
	; this text is not associated with a frame
	if (nAttributes& ATTRIB_HIGHLIGHT) then
			SayHighlightedText97 (hwnd,buffer)
	else
		SayNonHighlightedText (hwnd, buffer)
	endIf
else
	; this text is associated with a frame
	if (nEcho == ECHO_NONE) then
		return; frame is being silenced
	endif
	if (nEcho  == ECHO_ALL ||
	   (nAttributes & ATTRIB_HIGHLIGHT)) then
		; if FrameEcho is set to all or the text being written is highlighted
		Say(buffer, ot_buffer)
	endif
endif
EndFunction

Int Function WinwordHotKeyHelp ()
var
String strRealName,
String strPage,
int bSuccess
let strRealName = GetWindowName (GetRealWindow (GetFocus ()))
if (strRealName == wnTemplatesAndAddIns) then
	Say(msg288, ot_help) ;"Hot keys are as follows"
	Say(msgDocumentTemplate, ot_help)
	Say(msgAttach, ot_help)
	Say(msgUpdateDocStyles, ot_help)
	Say(msgGlobalTemplates, ot_help)
	Say(msgAdd, ot_help)
	Say(msgOrganizer, ot_help)
	return TRUE
elif (strRealName == wnPageSetup) then
	let strPage = GetDialogPageName ()
	Say(msg288, ot_help) ;"hot keys are as follows"
	if (strPage == fsMargins) then
		Say(msgTop, ot_help)
		Say(msgBottom, ot_help)
		Say(msgLeft, ot_help)
		Say(msgRight, ot_help)
		Say(msgGutter, ot_help)
		Say(msgHeader, ot_help)
		Say(msgFooter, ot_help)
		Say(msgApplyTo, ot_help)
		Say(msgDefault, ot_help)
		Say(msgMirrorMargins, ot_help)
	elif (strPage == fsPaperSize) then
		Say(msgPaperSize, ot_help)
		Say(msgWidth, ot_help)
		Say(msgHeight, ot_help)
		Say(msgPortrait, ot_help)
		Say(msgLandscape, ot_help)
		Say(msgApplyTo, ot_help)
		Say(msgDefault, ot_help)
	elif (strPage == fsPaperSource) then
		Say(msgFirstPage, ot_help)
		Say(msgOtherPages, ot_help)
		Say(msgApplyTo, ot_help)
		Say(msgDefault, ot_help)
	elif (strPage == fsLayout) then
		Say(msgSectionStart, ot_help)
		Say(msgDifferentOddEven, ot_help)
		Say(msgDifferentFirstPage, ot_help)
		Say(msgVerticalAlignment, ot_help)
		Say(msgApplyTo, ot_help)
		Say(msgDefault, ot_help)
		Say(msgLineNumbers, ot_help)
	endif
	return TRUE
elif (strRealName == wnInsertTable) then
	Say(msg288, ot_help) ;"Hot keys are as follows"
	Say(msgNumberOfColumns, ot_help)
	Say(msgNumberOfRows, ot_help)
	Say(msgColumnWidth, ot_help)
	Say(msgWizard, ot_help)
	Say(msgAutoFormat, ot_help)
	return TRUE
elif (strRealName == wnFormula) then
	Say(msg288, ot_help) ;"hot keys are as follows"
	Say(msgFormula, ot_help)
	Say(msgNumberFormat, ot_help)
	Say(msgPasteFunction, ot_help)
	Say(msgPasteBookmark, ot_help)
	return TRUE
elif (strRealName == wnFont) then
	let strPage = GetDialogPageName ()
	Say(msg288, ot_help) ;"Hot keys are as follows"
	if (strPage == fsCharacterSpacing) then
		Say(msgSpacing, ot_help)
		Say(msgSpacingBy, ot_help)
		Say(msgPosition, ot_help)
		Say(msgPositionBy, ot_help)
		Say(msgKerningForFonts, ot_help)
		Say(msgPointsAndAbove, ot_help)
	else
		Say(msgFont2, ot_help)
		Say(msgFontStyle, ot_help)
		Say(msgSize, ot_help)
		Say(msgUnderline, ot_help)
		Say(msgColor, ot_help)
		Say(msgStrikeThrough2, ot_help)
		Say(msgSuperScript2, ot_help)
		Say(msgSubScript2, ot_help)
		Say(msgHidden2, ot_help)
		Say(msgSmallCaps2, ot_help)
		Say(msgAllCaps2, ot_help)
	endif
	Say(msgDefault, ot_help)
	return TRUE
else
	return FALSE
endif
EndFunction

Script  SayDefaultButton()
var
	HANDLE WinHandle,
	int SDMControl
; figure out if we're in a dialog box
let WinHandle = GetRealWindow(GetFocus ())
if (GetWindowTypeCode (WinHandle )== WT_DIALOG) then
	if (GetVerbosity () == 0) then
		Say(msg70, ot_message) ;"default button is"
	EndIf
	Say(GetDefaultButtonName (), ot_control_name)
	return
EndIf ; regular dialog
; now check for sdm dialog
;wwc294="_sdm_"
if (StringContains (GetWindowClass (WinHandle), wwc294)) then
	if (GetWindowTypeCode (WinHandle) == WT_BUTTON) then
		if GetVerbosity() == beginner then
			Say(msg70, ot_message) ;"Default button is "
		EndIf
		SdmSayWindowTypeAndText (WinHandle, SdmGetFocus (WinHandle))
		return
		EndIf ; if control with focus is a button
		Say(wmsg470, ot_message) ;"unable to determine the default button In this dialog"
	; work our way through all child windows of the dialog
	return
endif ; sdm dialog active
Say(msg71, ot_message) ;"not in a dialog box"
EndScript

Script ReadBoxInTabOrder ()
var
	HANDLE WinHandle,
	int SDMControl
; figure out if we're in a dialog box
let WinHandle = GetRealWindow(GetCurrentWindow())
if (GetWindowTypeCode (WinHandle )== WT_DIALOG) then
	if GetVerbosity() == 0 then
		Say(msg34, ot_message) ;"Reed Box in tab order "
	EndIf
	Say(GetWindowName (WinHandle), ot_window_name)
; work our way through all child windows of the dialog
	let WinHandle   = GetFirstChild (WinHandle)
	while (WinHandle)
		SayControl (WinHandle)
		let WinHandle = GetNextWindow (WinHandle)
	EndWhile
	return
endif ; regular dialog active
; now check for sdm dialog
let WinHandle = GetRealWindow(GetCurrentWindow())
;wwc294="_sdm_"
if (StringContains (GetWindowClass (WinHandle), wwc294)) then
; this is an sdm dialog
	if GetVerbosity() == beginner then
		Say(msg34, ot_message) ;"Reed Box in tab order "
	EndIf
	Say(GetWindowName (WinHandle), ot_window_name)
	; work our way through all child windows of the dialog
	SaveCursor ()
	InvisibleCursor ()
	let SDMControl   = SDMGetFirstControl (WinHandle)
	while (SDMControl)
		MoveToControl (WinHandle, SDMControl)
		SayObjectTypeAndText ()
		let SDMControl = SDMGetNextControl (WinHandle, SDMControl)
	EndWhile
	RestoreCursor ()
	return
EndIf ; sdm dialog active
Say(msg35, ot_message) ;"Not a dialog box"
EndScript



Script LeftJustify ()
{control + l}
Pause ()
Say(wmsg417, ot_message) ;"Left aligned"
EndScript

Script  CenterText()
{control + e}
Pause ()
Say(wmsg418, ot_message) ;"centered"
EndScript

Script  RightJustify()
{control + r}
Pause ()
Say(wmsg419, ot_message) ;"right aligned"
EndScript

Script  JustifyText()
{control + j}
Pause ()
Say(wmsg420, ot_message) ;"Justified"
EndScript

Script  DeleteWord()
; delete current word and speak the word the PC cursor lands on.
{Control+Delete}
PCCursor ()
delay (1) ; causes a one tenth if a second delay to land on the word we want.
SayWord ()
EndScript

Script  SayField()
SayField()
EndScript

Function SaySDMFocusedWindow ()
let InMainDocumentWindow = false
let GlobalCurrentControl = SdmGetFocus (GlobalFocusWindow)

If (GlobalPrevReal != GlobalRealWindow)
|| GlobalRealWindowName != GlobalPrevRealName then
	SDMSayWindowTypeAndText (GlobalRealWindow,0) ; dialog box name
;	SayWindowTypeAndText (GlobalRealWindow) ; dialog box name
;	SdmSayStaticText (GlobalRealWindow) ;dialog box text
EndIf ; new real window handle or name
if (GetWindowName (GlobalFocusWindow) == wn_SpellingAndGrammar) then
	if (GlobalCurrentControl == CId_NotInDictionary_EditBox) then
		let spellcheckerTriggered=true
		performScript readMistakeAndSuggestion()
		let spellcheckerTriggered=false
		return
	EndIf
EndIf

; now say the current control
; If (GlobalCurrentControl > 0) then
; 	SdmSayWindowTypeAndText (GlobalFocusWindow, GlobalCurrentControl)
; EndIf ; control id > 0
SayFocusedObject ()
EndFunction

Void Function SayHighLightedText97 (handle hwnd, string buffer)
; avoid reading highlighted word in doc window while spellcheck is in progress
; otherwise we get double speaking.
if getWindowClass(hwnd)==wc_mainDocumentWindow then
	if not inMainDocumentWindow then
		return
	endIf
endIf 
if spellcheckerTriggered then
; the trigger is reset in triggerSpellchecker.
	return
endIf
let eventTriggered = hwnd; flag to indicate that highlighted text was written in the window hwnd
if GetWindowClass (hwnd)==wc_MSOCommandBar then
	return
endif
if (GetWindowSubTypeCode (GetRealWindow (GetFocus ())) == wt_dialog)
&&
 (GetFocus () != hwnd) then
	return
EndIf
SayHighlightedText (hwnd, buffer)
EndFunction

Void Function readErrorAndSuggestion (int textColor, string errorString)
var
	handle WinHandle,
int PromptId,
string thePrompt

if  GetWordVersion ()==Word_9 then
	let WinHandle = GetParent (GetFocus ())
else
	let WinHandle = GetFocus ()
endIf 
let promptId=SDMGetPrevControl (winHandle, cId_NotInDictionary_EditBox)
SaveCursor ()
InvisibleCursor ()
if not moveToControl(winHandle,promptId) then
	routeInvisibleToPc()
	jawsPageUp()
	nextLine()
	JawsHome()
endIf
let thePrompt=getChunk()
say(thePrompt,ot_message)
moveToWindow(winhandle)
if textColor==rgbStringToColor(colorMisspelledWord) then
; found the misspelled word, announce and spell it
	say(errorString,ot_string)
	spellString(errorString)
; announce and spell suggestion
	moveToControl(winHandle,SDMGetNextControl (winHandle, cId_NotInDictionary_editBox))
	priorLine()
	if getObjectValue() !=noSelectedItem then 
		SayChunk()
		say(getObjectValue(),ot_message)
		SpellString (getObjectValue())
	else
		Say(msgNoSpellingSuggestions, ot_message)
	EndIf
elif textColor==rgbStringToColor(colorGrammaticalError) then
; grammatical error
	Say(errorString,ot_string)
	if thePrompt==capitalization_prompt then
		spellString(errorString)
	endIf 
; announce suggestion 
	moveToControl(winHandle,SDMGetNextControl (winHandle, cId_NotInDictionary_editBox))
	priorLine()
	sayChunk()
	if getObjectValue() !=noSelectedItem then
		say(GetObjectValue (),ot_message)
		if thePrompt==capitalization_prompt then
			spellString(getObjectValue())	
		endIf
	else
		Say(msgNoSuggestions, ot_message)
	EndIf
endIf
restoreCursor()
EndFunction

Script ReadMistakeAndSuggestion ()
var
	handle WinHandle,
int PromptId,
string thePrompt

if getWindowName(getFocus()) != wn_SpellingAndGrammar then
	say(wmsg308,ot_message) ; "Not in spell checker",
	return
endIf
if  GetWordVersion ()==Word_9 then
	let WinHandle = GetParent (GetFocus ())
else
	let WinHandle = GetFocus ()
endIf 
let promptId=SDMGetPrevControl (winHandle, cId_NotInDictionary_EditBox)
SaveCursor ()
InvisibleCursor ()
if not moveToControl(winHandle,promptId) then
	routeInvisibleToPc()
	jawsPageUp()
	nextLine()
	JawsHome()
endIf
let thePrompt=getChunk()
say(thePrompt,ot_message)
MoveToWindow(winhandle)
if FindColors (rgbStringToColor(colorMisspelledWord), ignoreColor, s_top) then
; found the misspelled word, announce and spell it
	sayField()
	spellString(getField())
; announce and spell suggestion
	moveToControl(winHandle,SDMGetNextControl (winHandle, cId_NotInDictionary_editBox))
	priorLine()
	if getObjectValue() !=noSelectedItem then 
		SayChunk()
		say(getObjectValue(),ot_message)
		SpellString (getObjectValue())
	else
		Say(msgNoSpellingSuggestions, ot_message)
	EndIf
elif findColors(rgbStringToColor(colorGrammaticalError),ignoreColor,s_top) then
; grammatical error
	SayField ()
	if thePrompt==capitalization_prompt then
		spellString(getField())
	endIf 
; announce suggestion 
	moveToControl(winHandle,SDMGetNextControl (winHandle, cId_NotInDictionary_editBox))
	priorLine()
	sayChunk()
	if getObjectValue() !=noSelectedItem then
		say(GetObjectValue (),ot_message)
		if thePrompt==capitalization_prompt then
			spellString(getObjectValue())	
		endIf
	else
		Say(msgNoSuggestions, ot_message)
	EndIf
; look for blue hyperlinks which may be marked as misspelled.
elif FindColors (rgbStringToColor(colorHyperlink), ignoreColor, s_top) then
; found the misspelled word, announce and spell it
	sayField()
	spellString(getField())
; announce and spell suggestion
	moveToControl(winHandle,SDMGetNextControl (winHandle, cId_NotInDictionary_editBox))
	priorLine()
	if getObjectValue() !=noSelectedItem then 
		SayChunk()
		say(getObjectValue(),ot_message)
		SpellString (getObjectValue())
	else
		Say(msgNoSpellingSuggestions, ot_message)
	EndIf
endIf
restoreCursor()
return
EndScript

Script SayFont ()
var
	object oSelection,
	object oFont,
	int font,
	string strBuffer,
	object controls,
	object oParagraphFormat,
	int paragraphFormat
if not (IsPCCursor ()) then
	PerformScript SayFont ()
	if (GetWindowClass (GetCurrentWindow ()) == wc_MainDocumentWindow) then
		Say(msgForAccurate, ot_font)
	EndIf
	return; all done, jaws or invisible cursor is on
EndIf; is not pc cursor
if (GetWindowClass (GetCurrentWindow ()) != wc_MainDocumentWindow) then
	PerformScript SayFont ()
	return
EndIf
if IsSameScript () then
	Say(msgInsertionPointFormatting, ot_message)
	let oSelection = oWord.Selection
else
	Say(msgCurrentCharFormatting, ot_font)
	let oSelection = oWord.Selection.Range
EndIf
let oFont = oSelection.Font
let font = oFont.Bold
if (font) then
	if (Font != wdUndefined) then
		Say(wmsg318, ot_font) ;"bolded"
	EndIf
EndIf
let font = oFont.Italic
if (font) then
	if (Font != wdUndefined) then
		Say(wmsg320, ot_font) ;"italicized"
	EndIf
EndIf
let font = oFont.Underline
if (font) then
	if (Font != wdUndefined) then
		If Font == WDUnderlineWords Then ;Next 24 lines added by KAG to distinguish underline styles
			Say(wmsg523, ot_font) ;words only
		EndIf
		If Font == WDUnderlineDouble Then
			Say(wmsg524, ot_font) ;double
		EndIf
		If Font == WDUnderlineDotted Then
			Say(wmsg525, ot_font) ;dotted
		EndIf
		If Font == WDUnderlineThick Then
			Say(wmsg526, ot_font) ;thick
		EndIf
		If Font == WDUnderlineDash Then
			Say(wmsg527, ot_font) ;dash
		EndIf
		If Font == WDUnderlineDotDash Then
			Say(wmsg528, ot_font) ;dot dash
		EndIf
		If Font == WDUnderlineDotDotDash  Then
			Say(wmsg529, ot_font) ;dot dot dash
		EndIf
		If Font == WDUnderlineWavy  Then
			Say(wmsg530, ot_font) ;wavy
		EndIf
		Say(wmsg322, ot_font) ;"underlined"
	EndIf
EndIf
let font = oFont.DoubleStrikeThrough
if (font) then
	if (Font != wdUndefined) then
		Say(msgDoubleStrikeThrough, ot_font)
	EndIf
EndIf
let font = oFont.StrikeThrough
if (font) then
	if (Font != wdUndefined) then
		Say(msgStrikeThrough, ot_font)
	EndIf
EndIf
let font = oFont.Shadow
if (font) then
	if (Font != wdUndefined) then
		Say(msgShadowed, ot_font)
	EndIf
EndIf
let font = oFont.Subscript
if (font) then
	if (Font != wdUndefined) then
		Say(msgSubscript, ot_font)
	EndIf
EndIf
let font = oFont.Superscript
if (font) then
	if (Font != wdUndefined) then
		Say(msgSuperscript, ot_font)
	EndIf
EndIf
let font = oFont.Outline
if (font) then
	if (Font != wdUndefined) then
		Say(msgOutlined, ot_font)
	EndIf
EndIf
let font = oFont.Emboss
if (font) then
	if (Font != wdUndefined) then
		Say(msgEmbossed, ot_font)
	EndIf
EndIf
let font = oFont.Engrave
if (font) then
	if (Font != wdUndefined) then
		Say(msgEngraved, ot_font)
	EndIf
EndIf
let font = oFont.SmallCaps
if (font) then
	if (Font != wdUndefined) then
		Say(msgSmallCaps, ot_font)
	EndIf
EndIf
let font = oFont.AllCaps
if (font) then
	if (Font != wdUndefined) then
		Say(msgAllCaps, ot_font)
	EndIf
EndIf
let font = oFont.Hidden
if (font) then
	if (Font != wdUndefined) then
		Say(msgHidden, ot_font)
	EndIf
EndIf
if !IsSameScript () then
	if ((oSelection.End - oSelection.start) > 0) then
	; the selection range is not collapsed, then there is something highlighted
		Say(msgHighlighted, ot_font)
	EndIf
EndIf
let strBuffer = oSelection.Style.NameLocal
if (strBuffer != "") then
	Say(strBuffer, ot_buffer)
else
	Say(msgMixedStyle, ot_font)
EndIf
let strBuffer = oFont.Name
if (strBuffer != "") then
	Say(strBuffer, ot_buffer)
else
	Say(msgMixedFont, ot_font)
EndIf
let strBuffer = oWord.commandbars("formatting").controls(3).text()
if (strBuffer != "") then
	Say(strBuffer + msgPoint, ot_buffer)
else
	Say(msgMixedSize, ot_font)
EndIf
; paragraph formatting
Say(msgParagraphFormatting, ot_font)
let oParagraphFormat = oSelection.Paragraphs.Format;
let paragraphFormat = oParagraphFormat.Alignment
if (paragraphFormat == wdAlignParagraphLeft) then
	Say(wmsg324, ot_font) ;"Aligned left"
elif (paragraphFormat == wdAlignParagraphCenter) then
	Say(wmsg326, ot_font)
elif (paragraphFormat == wdAlignParagraphRight) then
	Say(wmsg328, ot_font)
elif (paragraphFormat == wdAlignParagraphJustify) then
	Say(wmsg330, ot_font)
elif (paragraphFormat == wdUndefined) then
	Say(msgMixedAlignment, ot_font)
EndIf
let paragraphFormat = oParagraphFormat.OutLineLevel
if (paragraphFormat == wdOutlineLevelBodyText) then
	Say(msgOutlineLevel + msgBodyText, ot_font)
elif (paragraphFormat > 0) then
	Say(msgOutlineLevel + IntToString (paragraphFormat), ot_font)
EndIf
EndScript

Script BoldText ()
var
	object oSelection,
	object oFont
{control+b}
pause ()
let oSelection = oWord.Selection
let oFont = oSelection.Font
if (oFont.Bold) then
	Say(msgBoldOn, ot_status)
else
	Say(msgBoldOff, ot_status)
EndIf
EndScript

Script ItalicText ()
var
	object oSelection,
	object oFont
{control+i}
pause ()
let oSelection = oWord.Selection
let oFont = oSelection.Font
if (oFont.Italic) then
	Say(msgItalicOn, ot_status)
else
	Say(msgItalicOff, ot_status)
EndIf
EndScript

Script UnderlineText ()
var
	object oSelection,
	object oFont
{control+u}
pause ()
let oSelection = oWord.Selection
let oFont = oSelection.Font
if (oFont.Underline) then
	Say(msgUnderlineOn, ot_status)
else
	Say(msgUnderlineOff, ot_status)
EndIf
EndScript

;*** Tables handling subsection

OBJECT Function GetCurrentTable ()
var
	object obj;
let obj = oWord.Selection.Range;
obj.Collapse;
obj.Expand(wdTable);
return obj.Tables(1)
EndFunction

OBJECT Function GetCurrentCell ()
var
	object obj;
let obj = oWord.Selection.Range;
obj.Collapse;
return obj.Cells(1)
EndFunction

object Function GetCurrentColumn ()
var
	object obj
let obj = GetCurrentCell ()
return obj.Column
EndFunction

object Function GetCurrentRow ()
var
	object obj
let obj = GetCurrentCell ()
return obj.Row
EndFunction

Void Function SayCellCoordinates (object oCell, string voice)
SayUsingVoice(voice, msgColumn + IntToString (oCell.ColumnIndex), ot_string)
SayUsingVoice(voice, msgRow + IntToString (oCell.RowIndex), ot_string)
EndFunction



Script SayFirstCellInColumn ()
var
	object obj
let obj = GetCurrentColumn ()
if obj then
	SayCellContent (obj.Cells(1),false)
else
	Say(msgNotInATable, ot_message)
EndIf
EndScript

Script SayFirstCellInRow ()
var
	object obj
let obj = GetCurrentRow ()
if obj then
	SayCellContent (obj.Cells(1),false)
else
	Say(msgNotInATable, ot_message)
EndIf
EndScript

Script SayWindowPromptAndText ()
var
object cell

if menusActive() || dialogActive() then
	sayFocusedWindow()
	return
endIf
if inMainDocumentWindow then
	if oWord.selection.information(wdWithinTable) then
		let cell=getCurrentCell()
		sayCellContent(cell,true)
		sayCellCoordinates(cell, vctx_message)
	endIf
else
	SayFocusedWindow ()
endIf
EndScript

Script ConvertTableToText ()
var
	object obj
let obj = GetCurrentTable ()
if obj then
	let obj = obj.ConvertToText();
	obj.Collapse;
	obj.Select;
	Say(msgTableToText, ot_message)
else
	Say(msgNotInATable, ot_message)
EndIf
EndScript

Script HotKeyHelp ()
var
	handle WinHandle,
	int Verbosity
let WinHandle = GetFocus ()
let Verbosity = GetVerbosity ()
if (GetWindowName (WinHandle) == wn_SpellingAndGrammar) then
	Say(msgIncorrectWordAndSuggestion +
		GetScriptKeyName ("ReadMistakeAndSuggestion"), ot_help)
	Say(msgReadWordInContext +
		GetScriptKeyName ("ReadWordInContext"), ot_help)
If (Verbosity == Beginner) then
	Say(msgAppHotKeys, ot_help)
HotKeyHelpDefaultLoop ()
	return
EndIf
EndIf
if (StringContains (GetWindowClass (GetRealWindow (GetFocus ())), "_sdm_")) then
	Say(msgThisIs + GetWindowName(GetRealWindow(GetFocus())) + msgDialogBox, ot_help)
	Say(msgMoveBetweenControls, ot_help)
	Say(msgForScreenSensitiveHelp +
		GetScriptKeyName ("ScreenSensitiveHelp"), ot_help)
	;take care of some known problematic dialogs.  If it is not problematic, then
	;use the HotKeyHelpDefaultLoop
	if (!WinwordHotKeyHelp()) then HotKeyHelpDefaultLoop () endif
	return
else
Say(wmsg476, ot_help) ;"the following hot keys may be useful for using jaws with ms word"
Say(wmsg478 + GetScriptKeyName ("ControlDownArrow"), ot_help) ;"to move to the next  paragraph and read it use control + down arrow"
Say(wmsg479 + GetScriptKeyName ("ControlUpArrow"), ot_help) ;"to move to the previous paragraph and read it use control + up arrow"
Say(wmsg480 + GetScriptKeyName ("SayParagraph"), ot_help) ;"to say the current paragraph use control + numpad +"
Say(wmsg486 + GetScriptKeyName ("OpenListBox"), ot_help) ;"to move to the next sentence and read it use alt + down arrow"
Say(wmsg487 + GetScriptKeyName ("CloseListBox"), ot_help) ;"to move to the previous sentence and read it use alt + up arrow"
Say(wmsg488 + GetScriptKeyName ("SaySentence"), ot_help) ;"to say the current sentence use alt + numpad +"

Say(wmsg481 + GetScriptKeyName ("SayField"), ot_help) ;"to say the current field use control + insert + numpad 5"
Say(wmsg482 + GetScriptKeyName ("SayLineAndColumn"), ot_help) ;"to read the line and column use insert + delete"
Say(wmsg483 + GetScriptKeyName ("ToggleWritingMode"), ot_help) ;"to toggle the writing mode on and off use control + alt + I"
Say(wmsg484 + GetScriptKeyName ("SayFirstCellInColumn"), ot_help) ;"to read the first cell in a column use alt + 1"
Say(wmsg485 + GetScriptKeyName ("SayFirstCellInRow"), ot_help) ;"to say the first cell in the row use alt + 7"
Say(wmsg489 + GetScriptKeyName ("ConvertTableToText"), ot_help) ;"to convert a table to text use insert + F5"
say(wmsg493c+getScriptKeyName("selectATable"),ot_help) ; to select a table use 
Say(wmsg493b+getScriptKeyName("adjustJawsVerbosity"),ot_help) ; to toggle context detection and other verbosity settings use
Say(wmsg490 + GetScriptKeyName ("CloseOfficeAssistant"), ot_help) ;"to close the office assistant use control + insert + F4"
Say(wmsg491 + GetScriptKeyName ("SayWordVersion"), ot_help) ;"to here the version of MS Word being used use control + insert + v"
Say(wmsg494 + GetScriptKeyName ("WindowKeysHelp"), ot_help) ;"for a list of ms word short cut keys use insert + w"
EndIf
EndScript

Script WindowKeysHelp ()

var
	handle WinHandle,
	int Verbosity
let WinHandle = GetFocus ()
let Verbosity = GetVerbosity ()
if (GetWindowName (WinHandle) == wn_SpellingAndGrammar) then
	Say(msgIncorrectWordAndSuggestion +
		GetScriptKeyName ("ReadMistakeAndSuggestion"), ot_help)
	Say(msgReadWordInContext +
		GetScriptKeyName ("ReadWordInContext"), ot_help)
If (Verbosity == Beginner) then
	Say(msgAppHotKeys, ot_help)
	return
EndIf
EndIf
Say(wmsg495, ot_help) ;"the following Ms Word short cut keys may be useful"
Say(wmsg496, ot_help) ;"to create a new document use control + N"
Say(wmsg497, ot_help) ;"to open an existing document use control + O"
Say(wmsg498, ot_help) ;"to save a document use control + S"
Say(wmsg499, ot_help) ;"to print a document use control + P"
Say(wmsg500, ot_help);"to undo the last edit command use control + Z"
Say(wmsg501, ot_help) ;"to repeat the last edit command use control + Y"
Say(wmsg502, ot_help) ;"to cut the selected text to the clip board use control + X"
Say(wmsg503, ot_help) ;"to copy the selected text to the clip board use control + C"
Say(wmsg504, ot_help) ;"to paste text from the clip board into a document use control + V"
Say(wmsg505, ot_help) ;"to select the entire document use control + A"
Say(wmsg506, ot_help) ;"to search for specific words or phrases use control + F"
Say(wmsg507, ot_help) ;"to find and replace specific words or phrases use control + H"
Say(wmsg508, ot_help) ;"to go to a specific line paragraph or page use control + G"
Say(wmsg509, ot_help) ;"to center text with in a document use control + E"
Say(wmsg510, ot_help) ;"to left justify text with in a document use control + L"
Say(wmsg511, ot_help) ;"to right justify text with in a document use control + R"
Say(wmsg512, ot_help) ;"to justify text with in a document use control + J"
Say(wmsg513, ot_help) ;"to change the point size of the font use control + shift + P"
Say(wmsg514, ot_help) ;"to change the font type use control + shift + F"
Say(wmsg515, ot_help) ;"to delete the current word use control + delete"
say(wmsg516, ot_help) ;"to delete the previous word use control + back space"
Say(wmsg517, ot_help) ;"to bold text with in a document use control + B"
Say(wmsg518, ot_help) ;"to italicize text with in a document use control + I"
Say(wmsg519, ot_help) ;"to underline text with in a document use control + U"
Say(wmsg520, ot_help) ;"to insert a hyper link with in a document use control + K"
Say(wmsg521, ot_help) ;"to check spelling or grammar with in a document use F7"
Say(wmsg522, ot_help) ;"to name and save a document use F12"
EndScript

Script SayWindowTitle ()
var
	handle CurrentWindow,
	handle RealWindow,
	handle AppWindow
let CurrentWindow = GetCurrentWindow()
if (CurrentWindow > 0) then ; handle not 0
	let RealWindow = GetRealWindow (CurrentWindow)
	let AppWindow = GetAppMainWindow (CurrentWindow)
	if GetVerbosity() == 0 then
		Say(msg30, ot_message) ;"Title ="
	EndIf
	if (IsMultiPageDialog ()) then
		Say(GetWindowName (RealWindow), ot_window_name)
		Say(msg31, ot_message) ;"page is"
		Say(GetDialogPageName (), ot_dialog_name)
		return
	endif
	If AppWindow != CurrentWindow then
		Say(GetWindowName (AppWindow), ot_window_name)
	endif
	if StringContains (GetWindowClass (RealWindow), wwc294) then ; this is an SDM dialog
		Say(GetWindowName (RealWindow), ot_window_name)
		SayObjectTypeAndText ()
		return
	EndIf
	If ((RealWindow != AppWindow)
	   && (RealWindow != CurrentWindow)) then
		Say(GetWindowName (RealWindow), ot_window_name)
	endif
	Say(GetWindowName (CurrentWindow), ot_window_name)
else
	ScreenSensitiveHelpForUnknownClasses()  ; when handle =0
endif
EndScript

Script SayLineAndColumn ()
var
	handle WinHandle
let WinHandle = GetAppMainWindow (GetFocus ())
let WinHandle = GetFirstChild (WinHandle)
while (WinHandle && (GetWindowClass (WinHandle) != wc_StatusBar))
	let WinHandle = GetNextWindow (WinHandle)
EndWhile
if WinHandle then
	SaveCursor ()
	InvisibleCursor ()
	MoveToWindow (WinHandle)
	if FindString (WinHandle, fs_line, s_top, s_restricted) then
		SayWord ()
		NextWord ()
		SayWord ()
		NextWord ()
		SayWord ()
		NextWord ()
		SayWord ()
	else
		Say(msgLnNotFound, ot_message)
	EndIf
else
	Say(msgStatusBarNotFound, ot_message)
EndIf
EndScript

Script ToggleWritingMode ()
var
	handle WinHandle,
	int ActiveColor
let WinHandle = GetAppMainWindow (GetFocus ())
let WinHandle = GetFirstChild (WinHandle)
while (WinHandle && (GetWindowClass (WinHandle) != wc_StatusBar))
	let WinHandle = GetNextWindow (WinHandle)
EndWhile
if (WinHandle) then
	SaveCursor ()
	JawsCursor ()
	MoveToWindow (WinHandle)
	let ActiveColor = GetColorBackground ()
; wfs464 = "OVR" (OverWrite)
	if FindString (WinHandle, wfs464, s_bottom, s_restricted) then
		pause ()
		LeftMouseButton ()
		LeftMouseButton ()
		pause ()
		if (GetColorBackground () == ActiveColor) then
			RestoreCursor ()
			Say(wmsg465, ot_message) ; "OverWrite mode active"
		else
			RestoreCursor ()
			Say(wmsg466, ot_message) ; "Insert mode active"
		EndIf
	else
		RestoreCursor ()
		Say(msgWritingModeNotFound, ot_message)
	EndIf
else
	Say(msgStatusBarNotFound, ot_message)
EndIf
EndScript

Script CloseOfficeAssistant ()
var
	handle hWnd
SaveCursor()
JAWSCursor()
If (GetProgramVersion (GetAppFilePath ()) > 8) then
	let Hwnd = FindTopLevelWindow ("Agentanim", "")
Else
let hWnd = FindTopLevelWindow ("MSOAssistant", "")
EndIf
if (hWnd && IsWindowVisible (hWnd)) then
	MoveToWindow(hWnd)
  SpeechOff ()
  Pause ()		
	RightMouseButton ()
pause()
  Pause ()
	{h}
  SpeechOn ()
	RestoreCursor()
        Say(wmsg473, ot_message);"Office Assistant closed"
else
        Say(wmsg472, ot_message);"Office Assistant not found"
endif
EndScript

String Function getCellText (object cell)
var
int fieldCount,
int fieldIndex,
object formFields, ; collection
string theText,
string tmpStr

if isDocProtected() && Cell.range.formFields.count > 0 then
	let formFields=Cell.range.formFields
	let fieldCount=formFields.count
	let fieldIndex=1
	while fieldIndex <=fieldCount
		let tmpStr=formFields(fieldIndex).result
		let theText=theText+tmpStr+msge_space
		let fieldIndex=fieldIndex+1
	endWhile
else
	let theText=Cell.range.text
endIf
return theText
EndFunction

Void Function SayCellContent (object oCell, int includePrompt)
if oCell.range.characters.count > 1 then ; not a blank cell
	say(getCellText(oCell),ot_string)
else
	say(msge_blankCell,ot_message)
endIf
EndFunction

Void Function detectTables ()
var
object selection,
object currentCell, ; table cell if in a table
object currentTable,
int changedTableLocation, ; have we changed table location or just moved within the current cell?
int currentRow,
int currentColumn,
int maxRows,
int maxColumns

; globals for Braille support
let globalLastCellInTable=false
			let globalTableEndOfRow=false

; detect if we are in a table
let selection=oWord.selection
if selection.information(wdWithinTable) then

; are we in the same table or a new one?
; if we are in a table then we need to detect col/row changes and end of row markers
; also need to speak row and column titles as appropriate.
	let currentTable=selection.tables(1)

	if globalTableStart !=currentTable.range.start then
; this is a new table, we need to report it.
		sayUsingVoice(vctx_message, msge_table,ot_message)
		let globalTablePriorRow=0
		let globalTablePriorColumn=0 
		let globalTableStart=currentTable.range.start
	endIf
; we want to report when we change row or column or land on an end of row marker
; we also want to alert the user when they move into the last cell of a table so they don't 
;accidentally create a blank row by pressing tab again.
	if selection.isEndOfRowMark then
			sayUsingVoice(vctx_message, msge_EndOfRowMark,ot_message)
			let globalTablePriorColumn=0 ; reset so column will be reported when we move off the marker back into the prior cell  
			let globalTableEndOfRow=true
	else
		let changedTableLocation=false ; will set to true when we detect we have changed cells.
; need to use the GetCurrentCell function as just getting selection.cells(1) can fail.
		let currentCell=getCurrentCell()
		let currentRow=currentCell.rowIndex
		let currentColumn=currentCell.columnIndex
		let globalTableCell=currentCell
	let maxRows=currentTable.rows.count
; since all tables in word 97 are considered non-uniform, we cannot use the uniform property of the table object
; instead we'll test the column object to see if it is valid 
		if currentCell.Column then
; uniform
			let maxColumns=currentTable.columns.count
		else
; non-uniform
			let maxColumns=currentCell.row.cells.count
		endIf
		if currentColumn !=globalTablePriorColumn then
			sayUsingVoice(vctx_message, msgColumn+intToString(currentColumn)+msge_of+intToString(maxColumns),ot_message)
			let globalTablePriorColumn=currentColumn
			let changedTableLocation=true
		endIf
		if currentRow !=globalTablePriorRow then
			sayUsingVoice(vctx_message, msgRow+intToString(currentRow)+msge_of+intToString(maxRows),ot_message)
			let globalTablePriorRow=currentRow
			let changedTableLocation=true
		endIf
		if changedTableLocation then
			if currentColumn==maxColumns && currentRow==maxRows then
				let globalLastCellInTable=true
				sayUsingVoice(vctx_message, msge_lastCell,ot_message)
				if getVerbosity()==beginner && not isDocProtected() then
					sayUsingVoice(vctx_message, msge_warningCreateCells,ot_message)
				endIf
			endIf
		endIf
	endIf
else ; we are not in a table
	if globalTableStart >=0 then ; we've just moved out of a table
		sayUsingVoice(vctx_message,msge_outOfTable,ot_message)
		let globalTableStart=-1 ; -1 when not in a table.
		let globalTableCell=null
	endIf
endIf
EndFunction

Void Function detectStyles ()
; detect if the style has changed.
if oWord.selection.style.nameLocal != globalPriorStyle then
	sayUsingVoice(vctx_message,oWord.selection.style.nameLocal,ot_message)
	let globalPriorStyle=oWord.selection.style.nameLocal
endIf
EndFunction

Function SayFocusedWindow ()
let eventTriggered = globalFocusWindow; flag to indicate that the focus changed

if (GetWindowClass (GlobalFocusWindow) == wc_MainDocumentWindow) then
	let InMainDocumentWindow = true
; we've just switched here so can reset all vars to force reporting of style, tables, etc
	let globalPriorStyle="" ; reset to force announcement
	PCCursor ()
	if globalDetectContext==detectContextOn then
		detectTables()
	endIf
	Say(wmsg297, ot_control_name) ;"edit"
	return
else
; Warning, the inMainDocumentWindow global is very important
; it is used in sayNonHighlightedText to determine when highlighted text is being written to the document window when the focus is actually somewhere else
; it is also used elsewhere to flag that we are in the edit area of the document window. 
	let InMainDocumentWindow = false
EndIf

SayFocusedObject ()
EndFunction

Script toggleContextDetection ()
if globalDetectContext==detectContextOff then
	let globalDetectContext=detectContextOn
	say(msge_DetectContextOn, ot_message)
elif globalDetectContext==detectContextOn then
	let globalDetectContext=detectContextOff
	say(msge_detectContextOff, ot_message)
endIf
let globalTableStart=-1
let globalTableCell=null
EndScript

Script toggleStyleDetection ()
if globalDetectStyleChanges==detectStylesOff then
	let globalDetectStyleChanges=detectStylesOn
	say(msge_DetectStylesOn, ot_message)
elif globalDetectStyleChanges==detectStylesOn then
	let globalDetectStyleChanges=detectStylesOff
	say(msge_detectStylesOff, ot_message)
endIf
let globalPriorStyle="" ; reset to force announcement
EndScript
Script ScreenSensitiveHelp ()
var
	handle WinHandle,
	string TheClass,
	int CId,
object CurrentCell,
object currentTable,
	object tableCollection,
object fieldCollection,
object currentField,
	object doc,
	int tableCount,
	int fieldCount,
	string strBuffer


if (IsSameScript ()) then
	AppFileTopic()
	return
EndIf
let WinHandle = GetCurrentWindow ()
let TheClass = GetWindowClass (WinHandle)
if (TheClass == wc_MainDocumentWindow) then
	let doc = oWord.ActiveDocument
	if doc then
		let tableCollection = doc.Tables
		let tableCount = tableCollection.Count
		if (tableCount > 0) then
			if tableCount == 1 then
				let strBuffer = strBuffer + IntToString (tableCount) + msgTable
			else
				let strBuffer = strBuffer + IntToString (tableCount) + msgTables
			EndIf
		EndIf
		let fieldCollection = doc.fields
		let fieldCount = fieldCollection.Count
		if (fieldCount > 0) then
			if (tableCount > 0) then
				let strBuffer = strBuffer + msgAnd
			EndIf
			if fieldCount == 1 then
				let strBuffer = strBuffer + IntToString (fieldCount) + msgField
			else
				let strBuffer = strBuffer +intToString(fieldCount)+ msgFields
			EndIf
		EndIf
		if (tableCount > 0 || fieldCount > 0) then
			let strBuffer = msgDocContains + strBuffer
			Say(strBuffer, ot_buffer)
		EndIf
	EndIf
	let currentCell = GetCurrentCell ()
	if (currentCell) then
		Say(msgCell, ot_help)
		SayCellCoordinates (CurrentCell, vctx_pccursor)
		let currentTable = GetCurrentTable ()
		Say(msgTableContaining +
			IntToString (currentTable.Columns.count) +
			msgColumns +
			msgAnd +
			IntToString (currentTable.Rows.count) +
			msgRows, ot_help)
		Say(msgReadCellLine, ot_help)
		Say(msgThruCells, ot_help)
		Say(msgSelectCellContent, ot_help)
		Say(msgHearCellContent +
			GetScriptKeyName ("SayWindowPromptAndText"), ot_help)
	else
		Say(msgMainDocWindow, ot_help)
		Say(msgReadingEditingFuncs, ot_help)
		Say(msgMenusToManipulate, ot_help)
	endIf
	sayDocumentProtectionStatus()
	if isDocProtected() then
; some protection scheme applies.
		Say(msg1296,ot_help)
	endIf
	return
endIf
if (GetWindowName (WinHandle) == wn_SpellingAndGrammar) then
	let CId = SDMGetCurrentControl ()
	if (CId == CId_NotInDictionary_EditBox) then
		Say(msgWordInQuestion, ot_help)
		Say(msgEditToCorrect, ot_help)
		Say(msgNextControl, ot_help)
		Say(msgMoreDetails, ot_help)
		return
	EndIf
EndIf
if (GlobalMenuMode == MENUBAR_ACTIVE) then
  Say(wmsg532, ot_help)
say(wmsg533, ot_help)
Say(wmsg534, ot_help)
Say(wmsg535, ot_help)
Say(wmsg536, ot_help)
	return
endif
if (GlobalMenuMode == MENU_ACTIVE) then
	ScreenSensitiveHelpForKnownClasses (wt_menu)
	return
EndIf
PerformScript ScreenSensitiveHelp ()
EndScript


Script selectATable ()
var
string tableDesc,
string tableDimensions,
string TableList,
object table,
int rowCount,
int columnCount,
int count,
int index,
int choice

if !oWord.ActiveDocument then
	say(msge_NotInDocumentWindow,ot_message)
	return
endIf 
let count=oWord.activeDocument.tables.count
if count==0 then
	say(msge_noTables,ot_message)
	return
endIf
let index=1
while index <=count
	let table=oWord.activeDocument.tables(index)
	let rowCount=table.rows.count
	let columnCount=table.columns.count
	let tableDimensions=intToString(columnCount)+msgColumns+msge_space+intToString(rowCount)+msgRows
	let tableDesc=msge_table+intToString(index)+msge_space+tableDimensions
	let tableList=tableList+tableDesc+LIST_ITEM_SEPARATOR 
	let index=index+1
endWhile
let tableList=stringLeft(tableList,stringLength(tableList)-1) ; remove the trailing delimiter to avoid an empty list item
let choice=DlgSelectItemInList (tableList, msge_SelectATableDialogName, false)
if choice then
	if oWord.activeDocument.protectionType==wdAllowOnlyFormFields then
; we need to focus on the first formfield in the table rather than the first cell
		oWord.activeDocument.tables(choice).range.formFields(1).select
	else
		oWord.activeDocument.tables(choice).select
	endIf
	oWord.selection.collapse
endIf
EndScript

Function sayDocumentProtectionStatus ()
var
int type
let type=oWord.activeDocument.protectionType
say(msg1295,ot_message)
if type==wdAllowOnlyComments then
	say(msg1291,ot_message)
elif type==wdAllowOnlyFormFields then
	say(msg1292,ot_message)
elif type==wdAllowOnlyRevisions then
	say(msg1293,ot_message)
elif type < 0 then ;==wdNoProtection then
	say(msg1294,ot_message)
endIf
EndFunction

Script readTableColumn ()
var
object column,
int count,
int index

if oWord.selection.information(wdWithinTable)==false then
	say(msgNotInATable ,ot_message)
	return
endIf
let column=getCurrentColumn()
if !column then
	say(msgNonUniform+msge_table,ot_message)
;	return
endIf
let count =column.cells.count
let index=1
while index <=count
	sayCellContent(column.cells(index),false)
	let index=index+1
endWhile
EndScript

Script readTableRow ()
var
object row,
int count,
int index

if oWord.selection.information(wdWithinTable)==false then
	say(msgNotInATable ,ot_message)
	return
endIf
let row=getCurrentRow()
let count =row.cells.count
let index=1
while index <=count
	sayCellContent(row.cells(index),false)
	let index=index+1
endWhile
EndScript

Script tabKey ()
var
int Typing_echo
Let Typing_Echo=GetDefaultJCFOption (opt_typing_Echo)

If (Typing_Echo != 0) Then
	say(wmsg540,ot_message)
endIf
{tab}
pause()
if isPcCursor() && inMainDocumentWindow then
	if globalDetectContext then
		detectTables()
endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
endIf
EndScript

Script shiftTabKey ()
var
int Typing_echo
Let Typing_Echo=GetDefaultJCFOption (opt_typing_Echo)

If (Typing_Echo != 0) Then
	say(wmsg541,ot_message)
endIf
{shift+tab}
Pause()
if isPcCursor() && inMainDocumentWindow then
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
endIf
EndScript

int Function isDocProtected ()
return oWord.activeDocument.protectionType >=0
EndFunction

Script fontDialog ()
Say(msgFont, ot_font)
{Control+Shift+F}
EndScript

Script PointSize ()
Say(msgPointSize, ot_font)
{Control+Shift+P} ; Word command
EndScript

Script Style ()
Say(msgStyle, ot_font)
{Control+Shift+S} ; Word command
EndScript

Script AdjustJAWSVerbosity ()
var     string list
if (IsSpeechOff ()) then
         PerformScript MuteSynthesizer()
         return
endif
let list = StyleDetectionItem+
contextDetectionItem+
VerbosityLevelItem +
         ScreenEchoItem +
         TypingEchoItem  +
         SayAllByItem +
PunctuationLevelItem+
FormatItem +
         GraphicsItem +
         AnsiCharsIncItem+
         BrailleVerbosityItem+

         MuteSynth
         DlgSelectScriptToRun (list, AdjustJawsVerbosityDialogName, false)
EndScript

Void Function ItemNotFoundEvent (int hwnd)
; event indicating that the requested item can't be found in the OSM
; avoid getting beep when cursoring in tables
; by overriding the event in this application 
if inMainDocumentWindow then
	return
else
	beep()
endIf
EndFunction

object Function getRangeAtCursor ()
; This function is currently not used but will be used once the GetPoint method, 
;its reciprocal method is useable.
 var
object null,
object range

If (GetProgramVersion (GetAppFilePath ()) > Word_8) && (getWindowClass(getcurrentWindow())==wc_mainDocumentWindow) then
; word 2000 supports this function
; also, getCursorCol and row return one pixel different to what rangeFromPoint sees as the correct point
	let range=oWord.activeWindow.rangeFromPoint(GetcursorCol()-1, getCursorRow()-1)
	if range then
		return range
	else
		return null
	endIf
else
; Word 97 does not support this function
	return null
endIf
EndFunction

Object Function GetCurrentSentence ()
var
object range,
object null
let range=oWord.selection
if range then
	return range.sentences(1)
else
	return null
endIf
EndFunction

object Function GetPriorSentence ()
var
object range,
object null
if not isPcCursor() then
; can't relocate jaws or invisible cursors as the getPoint method cannot be used yet
; because JFW cannot receive values by reference after calling the method.

	return null
endIf

let range=oWord.selection.range
if range then
	if range.move(wdSentence,-1) ==-1 then
		range.select
		return range.sentences(1)
		endIf
endIf
	return null
EndFunction

object Function GetNextSentence ()
var
object range,
object null
if not isPcCursor() then
; can't relocate jaws or invisible cursors as the getPoint method cannot be used yet
; because JFW cannot receive values by reference after calling the method.

	return null
endIf
let range=oWord.selection.range
if range then
	if range.move(wdSentence,1)==1 then
		range.select
		return range.sentences(1)
	endIf
endIf
return null
EndFunction

object Function GetCurrentParagraph ()
var
object range,
object null
let range=oWord.selection.range
if range then
	return range.paragraphs(1).range
else
	return null
endIf
EndFunction

object Function GetPriorParagraph ()
var
object range,
object null,
int canMoveByParagraph

if not isPcCursor() then
; can't relocate jaws or invisible cursors as the getPoint method cannot be used yet
; because JFW cannot receive values by reference after calling the method.

	return null
endIf

let range=oWord.selection.range
if range then
	let canMoveByParagraph=range.move(wdParagraph,-1)
	while range.paragraphs(1).range.text ==vbcr && canMoveByParagraph==-1 
		let canMoveByParagraph=range.move(wdParagraph,-1)
	endwhile
	range.select()
	return range.paragraphs(1).range
else
	return null
endIf
EndFunction

object Function GetNextParagraph ()
var
object range,
object null,
int canMoveByParagraph


if not isPcCursor() then
; can't relocate jaws or invisible cursors as the getPoint method cannot be used yet
; because JFW cannot receive values by reference after calling the method.

	return null
endIf

let range=oWord.selection.range
if range then
	let canMoveByParagraph=range.move(wdParagraph,1)
	while range.paragraphs(1).range.text ==vbcr && canMoveByParagraph 
		let canMoveByParagraph=range.move(wdParagraph,1)
	endwhile
	range.select()
	return range.paragraphs(1).range
else
	return null
endIf
EndFunction

Script SaySentence ()
var
object sentence
let sentence=getCurrentSentence()
if sentence then
	say(sentence.text,ot_message)
	return
endIf
performScript saySentence() ; default
EndScript

Script SayPriorSentence ()
var
object sentence

let sentence=getPriorSentence()
if sentence then
	say(sentence.text,ot_message)
else
	performScript sayPriorSentence() ; default
endIf
if isPcCursor() && inMainDocumentWindow then
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
endIf
EndScript

Script SayNextSentence ()
var
object range
let range=getNextSentence()
if range then
	say(range.text,ot_message)
	return
else
	performScript sayNextSentence() ; default
endIf
if isPccursor() && inMainDocumentWindow then
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
endIf
EndScript

Script SayParagraph ()
var
object para
let para=getCurrentParagraph()
if para then
	say(para.text,ot_message)
	return
endIf
performScript sayParagraph() ; default
EndScript

Script SayPriorParagraph ()
var
object para
let para=getPriorParagraph()
if para then
	say(para.text,ot_message)
	return 
else
	performScript sayPriorParagraph() ; default
endIf
if isPcCursor() && inMainDocumentWindow then
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
endIf
EndScript

Script SayNextParagraph ()
var
object para
let para=getNextParagraph()
if para then
	say(para.text,ot_message)
	return 
else
	performScript sayNextParagraph() ; default
endIf
if isPccursor() && inMainDocumentWindow then
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
endIf
EndScript

; for four navigational arrows and say prior/next word, to speed up response time,
; we will override and only call default function if not in main document window with PC cursor active.
Script sayPriorCharacter ()
if isPcCursor() && inMainDocumentWindow then
	priorCharacter()
	if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	  SelectingText(TRUE)
	  pause ()
	  SelectingText(false)
	  return
	EndIf
	sayCharacter()
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
	return
else
	performScript sayPriorCharacter() ;default
endIf
EndScript

Script sayNextCharacter ()
if isPcCursor() && inMainDocumentWindow then
		nextCharacter()
	if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	  SelectingText(TRUE)
	  pause ()
	  SelectingText(false)
	  return
	EndIf
	sayCharacter()
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
else
	performScript sayNextCharacter() ; default
endIf
EndScript

Void Function SayLine ()
var
	object cell,
string cellText, ; is the chunk we get really in the cell?
	string strBuffer

if isPcCursor() && oWord.selection.information(wdWithinTable) then
	let cell = GetCurrentCell ()
	if cell then
		let cellText=getCellText(cell)
		let strBuffer = GetChunk()
		if strBuffer !="" && stringContains(cellText,strBuffer) then
			say(strBuffer,ot_buffer)
		else
			saveCursor()
			invisibleCursor()
			routeInvisibleToPc()
			priorChunk()
			let strBuffer=getChunk()
			restoreCursor()
			if strBuffer !="" && stringContains(cellText,strBuffer) then
				say(strBuffer,ot_buffer)
			else
				Say(msgBlank, ot_message)
			endIf
		EndIf
		return
	EndIf
endIf
sayLine()
EndFunction

Script sayPriorLine ()
if isPcCursor() && inMainDocumentWindow then
	priorLine()
	if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	  SelectingText(TRUE)
	  pause ()
	  SelectingText(false)
	  return
	EndIf
	sayLine()
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
else
	performScript sayPriorLine() ; default
endIf
EndScript

Script sayNextLine ()
if isPcCursor() && inMainDocumentWindow then
	nextLine()
	if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	  SelectingText(TRUE)
	  pause ()
	  SelectingText(false)
	  return
	EndIf
	sayLine()
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
else
	performScript sayNextLine() ; default
endIf
EndScript

Script sayPriorWord ()
if isPcCursor() && inMainDocumentWindow then
	priorWord()
	if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	  SelectingText(TRUE)
	  pause ()
	  SelectingText(false)
	  return
	EndIf
	sayWord()
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
else
	performScript sayPriorWord() ;default
endIf
EndScript

Script sayNextWord ()
if isPcCursor() && inMainDocumentWindow then
	nextWord()
	if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	  SelectingText(TRUE)
	  pause ()
	  SelectingText(false)
	  return
	EndIf
	sayWord()
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
else
	performScript sayNextWord() ;default
endIf
EndScript

Script jawsHome ()
performScript jawsHome() ; default
if isPcCursor() && inMainDocumentWindow then
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
endIf
EndScript


Script jawsEnd ()
performScript jawsEnd() ;default
if isPcCursor() && inMainDocumentWindow then
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
endIf
EndScript

Script jawsPageUp ()
performScript jawsPageUp() ;default
if isPcCursor() && inMainDocumentWindow then
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
endIf
EndScript

Script jawsPageDown ()
performScript jawsPageDown() ;default
if isPcCursor() && inMainDocumentWindow then
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
endIf
EndScript

Script PreviousPage ()
var
	handle nullHandle
let eventTriggered = nullHandle
{Control + Page Up}
delay (2)
ProcessNewText ()
if (!eventTriggered) then
	Say(msgPrevPage, ot_message)
	SayLine ()
EndIf
if isPcCursor() && inMainDocumentWindow then
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
endIf
EndScript

Script NextPage ()
var
	handle nullHandle
let eventTriggered = nullHandle
{Control + Page Down}
delay (2)
ProcessNewText ()
if (!eventTriggered) then
	Say(msgNextPage, ot_message)
	SayLine ()
EndIf
if isPcCursor() && inMainDocumentWindow then
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
endIf
EndScript

Script TopOfFile ()
performScript topOfFile() ; default
if isPcCursor() && inMainDocumentWindow then
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
endIf
EndScript

Script bottomOfFile ()
performScript bottomOfFile() ; default
if isPcCursor() && inMainDocumentWindow then
	if globalDetectContext then
		detectTables()
	endIf
	if globalDetectStyleChanges then
		detectStyles()
	endIf
endIf
EndScript

Int Function BrailleBuildTableCell ()
if globalTableStart < 0 then
	return false
endIf
if globalTableCell then
	brailleAddString(brlTable,0,0,0)
	if globalTableEndOfRow then
		brailleAddString(msge_EndOfRowMark,0,0,0)
	else
		brailleAddString(brlCol+intToString(globalTableCell.columnIndex)+brlRow+intToString(globalTableCell.rowIndex),0,0,0)
		BrailleAddString(getCellText(globalTableCell),getCursorCol(),getCursorRow(),getCharacterAttributes())
	endIf
	if globalLastCellInTable then
		brailleAddString(msge_lastCell,0,0,0)
	endIf
	return true
	else
	return false
endIf
EndFunction

int Function  BrailleBuildLine ()
if not brailleBuildLine() && inMainDocumentWindow then
	return brailleBuildTableCell()
else
	return false
EndIf
EndFunction

Script ReadWordInContext ()
var
	handle WinHandle,
object selection,
object currentCell,
object currentTable,
int currentRow,
int currentColumn,
int maxRows,
int maxColumns

let selection=oWord.selection
let WinHandle = GetParent (GetFocus ())
if (GetWindowName (WinHandle) == wn_SpellingAndGrammar) then

	saveCursor()
	invisibleCursor()
	routeInvisibleToPc()
	if findColors(rgbStringToColor(colorMisspelledWord),ignoreColor,s_top) then
		sayWindow(getCurrentWindow(),read_everything)
	elif findColors(rgbStringToColor(colorGrammaticalError),ignoreColor,s_top) then
		sayWindow(getCurrentWindow(),read_everything)
	elif findColors(rgbStringToColor(colorHyperlink),ignoreColor,s_top) then
		sayWindow(getCurrentWindow(),read_everything)
	endIf
	restoreCursor()
elif stringContains(getWindowName(getRealWindow(getFocus())), wwn167) then
; find and  replace dlg.
	if selection.start!=selection.end then
; not collapsed, must be something highlighted 
		if selection.sentences.count > 0 then
			say(selection.sentences(1).text,ot_message)
		else
			say(selection.paragraphs(1).range.text,ot_message) 
		endIf
	else
		Say (msg480, ot_message) ; "Word in context not found "
	endIf
elif selection.information(wdWithinTable) then
; we are in a table, read the context of the current cell.
	let currentTable=getCurrentTable()
	let currentCell=getCurrentCell()
	let currentRow=currentCell.rowIndex
	let currentColumn=currentCell.columnIndex
	let maxRows=currentTable.rows.count
; all word 97 tables are non-uniform though this is not strictly true
; its just that we cannot test the table object's uniform property
; we must instead look at the column object
	if currentCell.column then ; must be uniform
		let maxColumns=currentTable.columns.count
	else ; non-uniform, can't obtain the column object
		let maxColumns=currentCell.row.cells.count
	endIf
	sayUsingVoice(vctx_pcCursor, msgColumn+intToString(currentColumn)+msge_of+intToString(maxColumns),ot_message)
	sayUsingVoice(vctx_pcCursor, msgRow+intToString(currentRow)+msge_of+intToString(maxRows),ot_message)
	if currentColumn==maxColumns && currentRow==maxRows then
		sayUsingVoice(vctx_pcCursor, msge_lastCell,ot_message)
		if getVerbosity()==beginner && not isDocProtected() then
			sayUsingVoice(vctx_pcCursor, msge_warningCreateCells,ot_message)
		endIf
	endIf
else ; perform the default read word in context.
	performScript readWordInContext() ; default
endIf
EndScript

Script SayAppVersion ()
if wordVersion==word_9 then
	Say (oWord.name,ot_message)
	say(oWord.build,ot_message)
else
	performScript SayAppVersion () ; default
endIf
EndScript
